CREATE TABLE company_reports (
id INT AUTO_INCREMENT PRIMARY KEY,
label VARCHAR(255) NOT NULL,
report_date DATETIME NULL,
description TEXT,
report_type Enum( 'specific', 'market'),
companyId INT NOT NULL,
createdAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP,     
updatedAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
FOREIGN KEY (companyId) REFERENCES company(id) ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE company_reports_configuration (
id INT AUTO_INCREMENT PRIMARY KEY,
reportId INT NOT NULL,
value JSON NULL,   
createdAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP,     
updatedAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
FOREIGN KEY (reportId) REFERENCES company_reports(id) ON DELETE CASCADE
);


